--[[
rep.lua
This file defines the loot tables for all the rep factions.
]]

--Need to invoke the constants file 
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

--All rep loot tables go in this table
AtlasLoot_Data["AtlasLootRepItems"] = {
    EmptyInstance = {};
    
    Aldor1 = {
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r2#", "" },
        { 23149, "INV_Scroll_06", "=q2=Design: Gleaming Golden Draenite", "=ds=#p12# (305)" },
        { 23601, "INV_Scroll_03", "=q1=Plans: Flamebane Bracers", "=ds=#p2# (350)" },
        { 30842, "INV_Scroll_03", "=q1=Pattern: Flameheart Bracers", "=ds=#p8# (350)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r3#", "" },
        { 29129, "INV_Chest_Cloth_19", "=q3=Anchorite's Robes", "=ds=#a1#, #s5#" },
        { 28881, "Spell_Holy_SealOfWisdom", "=q2=Inscription of Discipline", "=ds=#s3# #e17#" },
        { 28878, "Spell_Holy_SealOfSalvation", "=q2=Inscription of Faith", "=ds=#s3# #e17#" },
        { 28885, "Spell_Holy_FistOfJustice", "=q2=Inscription of Vengence", "=ds=#s3# #e17#" },
        { 28882, "Spell_Holy_GreaterBlessingofSanctuary", "=q2=Inscription of Warding", "=ds=#s3# #e17#" },
        { 23145, "INV_Scroll_06", "=q2=Design: Royal Shadow Draenite", "=ds=#p12# (305)" },
        { 23603, "INV_Scroll_03", "=q1=Plans: Flamebane Gloves", "=ds=#p2# (360)" },
        { 29704, "INV_Scroll_03", "=q1=Pattern: Blastguard Belt", "=ds=#p7# (350)" },
        { 29693, "INV_Scroll_03", "=q1=Pattern: Flamescale Belt", "=ds=#p7# (350)" },
        { 30843, "INV_Scroll_03", "=q1=Pattern: Flameheart Gloves", "=ds=#p8# (360)" },
        { 24293, "INV_Scroll_03", "=q1=Pattern: Silver Spellthread", "=ds=#p8# (335)" },
        };
    
    Aldor2 = {
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r4#", "" },
        { 29127, "INV_Chest_Plate02", "=q3=Vindicator's Hauberk", "=ds=#s5#, #a4#" },
        { 29128, "INV_Jewelry_Ring_48Naxxramas", "=q3=Lightwarden's Band", "=ds=#s13#" },
        { 29130, "INV_Staff_14", "=q3=Auchenai Staff", "=ds=#w9#" },
        { 24177, "INV_Scroll_05", "=q3=Design: Pendant of Shadow's End", "=ds=#p12# (360)" },
        { 23604, "INV_Scroll_03", "=q1=Plans: Flamebane Breastplate", "=ds=#p2# (365)" },
        { 29703, "INV_Scroll_03", "=q1=Pattern: Blastguard Boots", "=ds=#p7# (350)" },
        { 29691, "INV_Scroll_03", "=q1=Pattern: Flamescale Boots", "=ds=#p7# (350)" },
        { 25721, "INV_Scroll_03", "=q1=Pattern: Vindicator's Armor Kit", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_SealOfSalvation", "=q6=#r5#", "" },
        { 29123, "INV_Jewelry_Amulet_04", "=q4=Medallion of the Lightbearer", "=ds=#s2#" },
        { 29124, "INV_Sword_Draenei_01", "=q4=Vindicator's Brand", "=ds=#h1#, #w10#" },
        { 28886, "Spell_Holy_SealOfWisdom", "=q3=Greater Inscription of Discipline", "=ds=#s3# #e17#" },
        { 28887, "Spell_Holy_GreaterBlessingofSalvation", "=q3=Greater Inscription of Faith", "=ds=#s3# #e17#" },
        { 28888, "Spell_Holy_GreaterBlessingofKings", "=q3=Greater Inscription of Vengence", "=ds=#s3# #e17#" },
        { 28889, "Spell_Holy_BlessingOfProtection", "=q3=Greater Inscription of Warding", "=ds=#s3# #e17#" },
        { 23602, "INV_Scroll_03", "=q1=Plans: Flamebane Helm", "=ds=#p2# (355)" },
        { 29702, "INV_Scroll_03", "=q1=Pattern: Blastguard Pants", "=ds=#p7# (350)" },
        { 29689, "INV_Scroll_03", "=q1=Pattern: Flamescale Leggings", "=ds=#p7# (350)" },
        { 24295, "INV_Scroll_03", "=q1=Pattern: Golden Spellthread", "=ds=#p8# (375)" },
        { 30844, "INV_Scroll_03", "=q1=Pattern: Flameheart Vest", "=ds=#p8# (370)" },
        { 31779, "INV_Shirt_GuildTabard_01", "=q1=Aldor Tabard", "=ds=#s7#" },
        };

    AQBroodRings = {
        { 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Conqueror"], "" },
       	{ 21201, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
       	{ 21202, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
       	{ 21203, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
       	{ 21204, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
       	{ 21205, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
       	{ 0,"","","" },
       	{ 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Invoker"], "" },
       	{ 21206, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
       	{ 21207, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
       	{ 21208, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
       	{ 21209, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
        { 21210, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Jewelry_Ring_40", "=q6="..AL["Path of the Protector"], "" },
        { 21196, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r1#" },
        { 21197, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r2#" },
        { 21198, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r3#" },
        { 21199, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r4#" },
        { 21200, "INV_Jewelry_Ring_40", "=q4=Signet Ring of the Bronze Dragonflight", "=ds=#s13#, =q1=#r5#" },
        };
    
    Argent1 = {
        { 22689, "INV_Helmet_13", "=q3=Sanctified Leather Helm", "=ds=#s1#, #a2#" },
        { 22690, "INV_Pants_03", "=q3=Leggings of the Plague Hunter", "=ds=#s11#, #a3#" },
        { 22681, "INV_Jewelry_Ring_33", "=q3=Band of Piety", "=ds=#s13#" },
        { 22680, "INV_Jewelry_Ring_01", "=q3=Band of Resolution", "=ds=#s13#" },
        { 22688, "INV_Weapon_ShortBlade_03", "=q3=Verimonde's Last Resort", "=ds=#h3#, #w4#" },
        { 22679, "INV_Misc_Bag_17", "=q3=Supply Bag", "=ds=#m14# #e1#" },
        { 0, "", "", "" },
        { 22638, "Spell_Shadow_AntiShadow", "=q3=Shadow Guard", "=ds=#s1# #e17#" },
        { 0, "", "", "" },  
        { 22523, "INV_Misc_Token_ArgentDawn", "=q2=Insignia of the Dawn", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 22667, "INV_Bracer_12", "=q4=Bracers of Hope", "=ds=#s8#, #a1#" },
        { 22668, "INV_Bracer_04", "=q4=Bracers of Subterfuge", "=ds=#s8#, #a2#" },
        { 22657, "INV_Jewelry_Amulet_04", "=q4=Amulet of the Dawn", "=ds=#s2#" },
        { 22659, "INV_Jewelry_Amulet_04", "=q4=Medallion of the Dawn", "=ds=#s2#" },
        { 22678, "INV_Misc_Gem_Pearl_04", "=q4=Talisman of Ascendance", "=ds=#s14#" },
        { 22656, "INV_Weapon_Rifle_06", "=q4=The Purifier", "=ds=#w5#" },
        { 0, "", "", "" },
        { 22636, "Spell_Frost_FrostShock", "=q3=Ice Guard", "=ds=#s1# #e17#" },
        { 0, "", "", "" },  
        { 22524, "INV_Misc_Token_ScarletCrusade", "=q2=Insignia of the Crusade", "=ds=#m17#" },
        };

    Argent2 = {
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r2#", "" },
        { 13724, "INV_Misc_Food_33", "=q1=Enriched Manna Biscuit", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r3#", "" },
        { 13482, "INV_Scroll_06", "=q2=Recipe: Transmute Air to Fire", "=ds=#p1# (275)" },
        { 19203, "INV_Scroll_03", "=q1=Plans: Girdle of the Dawn", "=ds=#p2# (290)" },
        { 19446, "INV_Misc_Note_01", "=q1=Formula: Enchant Bracer - Mana Regeneration", "=ds=#p4# (290)" },
        { 19442, "INV_Scroll_03", "=q1=Formula: Powerful Anti-Venom", "=ds=#p6# (300)" },
        { 19328, "INV_Scroll_03", "=q1=Pattern: Dawn Treaders", "=ds=#p7# (290)" },
        { 19216, "INV_Scroll_03", "=q1=Pattern: Argent Boots", "=ds=#p8# (290)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 12844, "INV_Jewelry_Talisman_08", "=q2=Argent Dawn Valor Token", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r4#", "" },
        { 18171, "Spell_Holy_WordFortitude", "=q2=Arcane Mantle of the Dawn", "=ds=#s3# #e17#" },
        { 18169, "Spell_Fire_FlameShock", "=q2=Flame Mantle of the Dawn", "=ds=#s3# #e17#" },
        { 18170, "Spell_Frost_FrostShock", "=q2=Frost Mantle of the Dawn", "=ds=#s3# #e17#" },
        { 18172, "Spell_Nature_ProtectionformNature", "=q2=Nature Mantle of the Dawn", "=ds=#s3# #e17#" },
        { 18173, "Spell_Shadow_RagingScream", "=q2=Shadow Mantle of the Dawn", "=ds=#s3# #e17#" },
        { 19205, "INV_Scroll_03", "=q1=Plans: Gloves of the Dawn", "=ds=#p2# (300)" },
        { 19447, "INV_Misc_Note_01", "=q1=Formula: Enchant Bracer - Healing", "=ds=#p4# (300)" },
        { 19329, "INV_Scroll_03", "=q1=Pattern: Golden Mantle of the Dawn", "=ds=#p7# (300)" },
        { 19217, "INV_Scroll_03", "=q1=Pattern: Argent Shoulders", "=ds=#p8# (300)" },
        { 13810, "INV_Misc_Food_41", "=q1=Blessed Sunfruit", "=ds=#e3#" },
        { 13813, "INV_Drink_16", "=q1=Blessed Sunfruit Juice", "=ds=#e4#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Talisman_08", "=q6=#r5#", "" },
        { 18182, "INV_Misc_Gem_Variety_02", "=q2=Chromatic Mantle of the Dawn", "=ds=#s3# #e17#" },
        };
        
    Ashtongue1 = {
        { 0, "INV_Misc_Gem_Pearl_05", "=q6=#r2#", "" },
        { 32444, "INV_Scroll_03", "=q1=Plans: Shadesteel Girdle", "=ds=#p2# (375)" },
        { 32442, "INV_Scroll_03", "=q1=Plans: Shadesteel Bracers", "=ds=#p2# (375)" },
        { 32436, "INV_Scroll_03", "=q1=Pattern: Redeemed Soul Cinch", "=ds=#p7# (375)" },
        { 32435, "INV_Scroll_03", "=q1=Pattern: Redeemed Soul Legguards", "=ds=#p7# (375)" },
        { 32430, "INV_Scroll_03", "=q1=Pattern: Bracers of Shackled Souls", "=ds=#p7# (375)" },
        { 32429, "INV_Scroll_03", "=q1=Pattern: Boots of Shackled Souls", "=ds=#p7# (375)" },
        { 32440, "INV_Scroll_03", "=q1=Pattern: Soulguard Girdle", "=ds=#p8# (375)" },
        { 32438, "INV_Scroll_03", "=q1=Pattern: Soulguard Bracers", "=ds=#p8# (375)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Gem_Pearl_05", "=q6=#r3#", "" },
        { 32443, "INV_Scroll_03", "=q1=Plans: Shadesteel Greaves", "=ds=#p2# (375)" },
        { 32441, "INV_Scroll_03", "=q1=Plans: Shadesteel Sabots", "=ds=#p2# (375)" },
        { 32433, "INV_Scroll_03", "=q1=Pattern: Redeemed Soul Mocassins", "=ds=#p7# (375)" },
        { 32434, "INV_Scroll_03", "=q1=Pattern: Redeemed Soul Wristguards", "=ds=#p7# (375)" },
        { 32431, "INV_Scroll_03", "=q1=Pattern: Greaves of Shackled Souls", "=ds=#p7# (375)" },
        { 32432, "INV_Scroll_03", "=q1=Pattern: Waistguard of Shackled Souls", "=ds=#p7# (375)" },
        { 32447, "INV_Scroll_03", "=q1=Pattern: Night's End", "=ds=#p8# (375)" },
        { 32439, "INV_Scroll_03", "=q1=Pattern: Soulguard Leggings", "=ds=#p8# (375)" },
        { 32437, "INV_Scroll_03", "=q1=Pattern: Soulguard Slippers", "=ds=#p8# (375)" },
        }; 

    Ashtongue2 = {
	{ 0, "INV_Misc_Gem_Pearl_05", "=q6=#r5#", "" },
        { 32486, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Equilibrium", "=ds=#s14#, =q1=#m1# =ds=#c1#" },
        { 32487, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Swiftness", "=ds=#s14#, =q1=#m1# =ds=#c2#" },
        { 32488, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Insight", "=ds=#s14#, =q1=#m1# =ds=#c3#" },
        { 32489, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Zeal", "=ds=#s14#, =q1=#m1# =ds=#c4#" },
        { 32490, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Acumen", "=ds=#s14#, =q1=#m1# =ds=#c5#" },
        { 32492, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Lethality", "=ds=#s14#, =q1=#m1# =ds=#c6#" },
        { 32491, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Vision", "=ds=#s14#, =q1=#m1# =ds=#c7#" },
        { 32493, "INV_Misc_Gem_Pearl_05", "=q4=Ashtongue Talisman of Shadows", "=ds=#s14#, =q1=#m1# =ds=#c8#" },
        { 32485, "INV_Jewelry_Necklace_18", "=q4=Ashtongue Talisman of Valor", "=ds=#s14#, =q1=#m1# =ds=#c9#" },
        }; 

    Bloodsail1 = {
        { 0, "INV_Helmet_66", "=q6=#r1#", "" },
        { 22742, "INV_Shirt_08", "=q1=Bloodsail Shirt", "=ds=#s5#" },
        { 22743, "INV_Misc_Bandana_03", "=q1=Bloodsail Sash", "=ds=#s10#" },
        { 22745, "INV_Pants_Cloth_02", "=q1=Bloodsail Pants", "=ds=#s11#" },
        { 22744, "INV_Boots_05", "=q1=Bloodsail Boots", "=ds=#s12#" },
        { 0, "", "", "" },
        { 0, "INV_Helmet_66", "=q6=#r2#", "" },
        { 12185, "INV_Helmet_66", "=q2=Bloodsail Admiral's Hat", "=ds=#s1#, #a1#" },
        };

    Cenarion1 = {
        { 22209, "INV_Scroll_03", "=q1=Plans: Heavy Obsidian Belt", "=ds=#p2# (300)" },
        { 22768, "INV_Scroll_03", "=q1=Plans: Ironvine Belt", "=ds=#p2# (300)" },
        { 20732, "INV_Misc_Note_01", "=q1=Formula: Enchant Cloak - Greater Fire Resistance", "=ds=#p4# (300)" },
        { 22769, "INV_Scroll_03", "=q1=Pattern: Bramblewood Belt", "=ds=#p7# (300)" },
        { 20509, "INV_Scroll_03", "=q1=Pattern: Sandstalker Bracers", "=ds=#p7# (300)" },
        { 20506, "INV_Scroll_03", "=q1=Pattern: Spitfire Bracers", "=ds=#p7# (300)" },
        { 22772, "INV_Scroll_03", "=q1=Pattern: Sylvan Shoulders", "=ds=#p8# (300)" },
        { 22310, "INV_Scroll_03", "=q1=Pattern: Cenarion Herb Bag", "=ds=#p8# (275)" },
        { 0, "", "", "" },
        { 20802, "INV_Jewelry_Talisman_06", "=q2=Cenarion Combat Badge", "=ds=#m17#" },
        { 20800, "INV_Jewelry_Necklace_16", "=q2=Cenarion Logistics Badge", "=ds=#m17#" },
        { 21515, "INV_Jewelry_Necklace_14", "=q2=Mark of Remulos", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21187, "INV_Misc_Cape_07", "=q3=Earthweave Cloak", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 21178, "INV_Gauntlets_18", "=q3=Gloves of Earthen Power", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 21179, "INV_Jewelry_Ring_18", "=q3=Band of Earthen Wrath", "", "", "5", "#ccombat#", "3", "#clogistics#", "7", "#ctactical#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20801, "INV_Jewelry_Amulet_02", "=q2=Cenarion Tactical Badge", "=ds=#m17#" },
        { 21508, "INV_Jewelry_Necklace_12", "=q2=Mark of Cenarius", "=ds=#m17#" },
        };
    
    Cenarion2 = {
        { 22767, "INV_Scroll_03", "=q1=Plans: Ironvine Gloves", "=ds=#p2# (300)" },
        { 22214, "INV_Scroll_03", "=q1=Plans: Light Obsidian Belt", "=ds=#p2# (300)" },
        { 20733, "INV_Misc_Note_01", "=q1=Formula: Enchant Cloak - Greater Nature Resistance", "=ds=#p4# (300)" },
        { 22770, "INV_Scroll_03", "=q1=Pattern: Bramblewood Boots", "=ds=#p7# (300)" },
        { 20510, "INV_Scroll_03", "=q1=Pattern: Sandstalker Gauntlets", "=ds=#p7# (300)" }, 
        { 20507, "INV_Scroll_03", "=q1=Pattern: Spitfire Gauntlets", "=ds=#p7# (300)" },
        { 22773, "INV_Scroll_03", "=q1=Pattern: Sylvan Crown", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21183, "INV_Chest_Cloth_06", "=q3=Earthpower Vest", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        { 21182, "INV_Jewelry_Ring_19", "=q3=Band of Earthen Might", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        { 21181, "INV_Misc_Herb_02", "=q3=Grace of Earth", "", "", "7", "#ccombat#", "4", "#clogistics#", "4", "#ctactical#" },
        };
    
    Cenarion3 = {
        { 22766, "INV_Scroll_03", "=q1=Plans: Ironvine Breastplate", "=ds=#p2# (300)" },
        { 22219, "INV_Scroll_03", "=q1=Plans: Jagged Obsidian Shield", "=ds=#p2# (300)" },
        { 22771, "INV_Scroll_03", "=q1=Pattern: Bramblewood Helm", "=ds=#p7# (300)" },
        { 20511, "INV_Scroll_03", "=q1=Pattern: Sandstalker Breastplate", "=ds=#p7# (300)" },
        { 20508, "INV_Scroll_03", "=q1=Pattern: Spitfire Breastplate", "=ds=#p7# (300)" },
        { 22683, "INV_Scroll_03", "=q1=Pattern: Gaea's Embrace", "=ds=#p8# (300)" },
        { 22312, "INV_Scroll_03", "=q1=Pattern: Satchel of Cenarius", "=ds=#p8# (300)" },
        { 22774, "INV_Scroll_03", "=q1=Pattern: Sylvan Vest", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21186, "INV_Bracer_12", "=q4=Rockfury Bracers", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21184, "INV_Bracer_07", "=q4=Deeprock Bracers", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21189, "INV_Jewelry_Ring_41", "=q4=Might of Cenarius", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        { 21185, "INV_Misc_Gem_Pearl_06", "=q4=Earthcalm Orb", "", "", "15", "#ccombat#", "20", "#clogistics#", "17", "#ctactical#", "1", "#cremulos#" },
        };
        
    Cenarion4 = {
        { 22221, "INV_Scroll_03", "=q1=Plans: Obsidian Mail Tunic", "=ds=#p2# (300)" },
        { 20382, "INV_Scroll_03", "=q1=Pattern: Dreamscale Breastplate", "=ds=#p7# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_QirajIdol_Amber", "=q6=#j8#", "" },
        { 21190, "INV_Jewelry_Ring_40", "=q4=Wrath of Cenarius", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },
        { 21180, "Spell_Nature_AbolishMagic", "=q4=Earthstrike", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },
        { 21188, "INV_Hammer_23", "=q4=Fist of Cenarius", "", "", "15", "#ccombat#", "20", "#clogistics#", "20", "#ctactical#", "1", "#ccenarius#" },        
        };   
         
    CExpedition1 = {
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r2#", "" },
        { 25737, "INV_Scroll_05", "=q3=Pattern: Heavy Clefthoof Boots", "=ds=#p7# (355)" },
        { 24417, "INV_Misc_Ammo_Arrow_05", "=q2=Scout's Arrow", "=ds=#w17#" },
        { 23814, "INV_Scroll_03", "=q1=Schematic: Green Smoke Flare", "=ds=#p5# (335)" },
        { 24429, "INV_Enchant_EssenceAstralSmall", "=q1=Expedition Flare", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r3#", "" },
        { 25838, "INV_Chest_Leather_08", "=q3=Warden's Hauberk", "=ds=#s5#, #a2#" },
        { 25836, "INV_Mace_11", "=q3=Preserver's Cudgel", "=ds=#h3#, #w6#" },
        { 25835, "INV_Staff_31", "=q3=Explorer's Walking Stick", "=ds=#w9#" },
        { 25735, "INV_Scroll_05", "=q3=Pattern: Heavy Clefthoof Vest", "=ds=#p7# (360)" },
        { 25736, "INV_Scroll_05", "=q3=Pattern: Heavy Clefthoof Leggings", "=ds=#p7# (355)" },
        { 29194, "Spell_Nature_ProtectionformNature", "=q2=Glyph of Nature Warding", "#s1# #e17#" },
        { 25869, "INV_Scroll_03", "=q1=Recipe: Transmute Earthstorm Diamond", "=ds=#p1# (350)" },
        { 32070, "INV_Scroll_03", "=q1=Recipe: Earthen Elixir", "=ds=#p1# (320)" },
        { 23618, "INV_Scroll_03", "=q1=Plans: Adamantite Sharpening Stone", "=ds=#p2# (350)" },
        { 28632, "INV_Scroll_03", "=q1=Plans: Adamantite Weightstone", "=ds=#p2# (350)" },
        { 25526, "INV_Scroll_03", "=q1=Plans: Greater Rune of Warding", "=ds=#p2# (350)" },
        { 29720, "INV_Scroll_03", "=q1=Pattern: Clefthide Leg Armor", "=ds=#p7# (335)" },
        };
        
    CExpedition2 = {
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r4#", "" },
        { 31392, "INV_Scroll_04", "=q4=Plans: Wildguard Helm", "=ds=#p2# (375)" },
        { 31391, "INV_Scroll_04", "=q4=Plans: Wildguard Leggings", "=ds=#p2# (375)" },
        { 29174, "INV_Helmet_34", "=q3=Watcher's Cowl", "=ds=#s1#, #a1#" },
        { 29173, "INV_Jewelry_Necklace_06", "=q3=Strength of the Untamed", "=ds=#s2#" },
        { 31949, "INV_Misc_Ammo_Arrow_02", "=q3=Warden's Arrow", "=ds=#w17#" },
        { 24183, "INV_Scroll_05", "=q3=Design: Nightseye Panther", "=ds=#p12# (370)" },
        { 29192, "Ability_Druid_DemoralizingRoar", "=q2=Glyph of Ferocity", "=ds=#s1# #e17#" },
        { 22918, "INV_Scroll_06", "=q2=Recipe: Transmute Primal Water to Air", "=ds=#p1# (350)" },
        { 28271, "INV_Misc_Note_01", "=q2=Formula: Enchant Gloves - Spell Strike", "=ds=#p4# (360)" },
        { 30623, "INV_Misc_Key_13", "=q1=Reservoir Key", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ammo_Arrow_02", "=q6=#r5#", "" },
        { 29170, "INV_Misc_Orb_01", "=q4=Windcaller's Orb", "=ds=#s15#" },
        { 29172, "INV_Jewelry_Ring_51Naxxramas", "=q4=Ashyen's Gift", "=ds=#s13#" },
        { 29171, "INV_Hammer_10", "=q4=Earthwarden", "=ds=#h2#, #w6#" },
        { 31390, "INV_Scroll_04", "=q4=Plans: Wildguard Breastplate", "=ds=#p2# (375)" },
        { 31402, "INV_Scroll_04", "=q4=Design: The Natural Ward", "=ds=#p12# (375)" },
        { 33149, "INV_Misc_Note_01", "=q3=Formula: Enchant Cloak - Stealth", "=ds=#p4# (300) (Patch 2.2)" },
        { 31356, "INV_Scroll_06", "=q2=Recipe: Flask of Distilled Wisdom", "=ds=#p1# (300)" },
        { 22922, "INV_Scroll_06", "=q1=Recipe: Major Nature Protection Potion", "=ds=#p1# (360)" },
        { 29721, "INV_Scroll_03", "=q1=Pattern: Nethercleft Leg Armor", "=ds=#p7# (365)" },
        { 31804, "INV_Shirt_GuildTabard_01", "=q1=Cenarion Expedition Tabard", "=ds=#s7#" },
        };
        
    Consortium1 = {
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r2#", "" },
        { 25732, "INV_Scroll_05", "=q3=Pattern: Fel Leather Gloves", "=ds=#p7# (340)" },
        { 28274, "INV_Misc_Note_01", "=q2=Formula: Enchant Cloak - Spell Penetration", "=ds=#p4# (325)" },
        { 23146, "INV_Scroll_06", "=q2=Design: Shifting Shadow Draenite", "=ds=#p12# (315)" },
        { 23136, "INV_Scroll_06", "=q2=Design: Luminous Flame Spessarite", "=ds=#p12# (305)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r3#", "" },
        { 29457, "INV_Weapon_ShortBlade_08", "=q3=Nethershard", "=ds=#h3#, #w4#" },
        { 29456, "INV_Sword_Draenei_01", "=q3=Gift of the Ethereal", "=ds=#h3#, #w10#" },
        { 29118, "INV_Misc_Bag_10_Black", "=q3=Smuggler's Ammo Pouch", "=ds=#m14# #w20# =q1=#m1# =ds=#c2#" },
        { 25733, "INV_Scroll_05", "=q3=Pattern: Fel Leather Boots", "=ds=#p7# (350)" },
        { 23134, "INV_Scroll_06", "=q2=Design: Delicate Blood Garnet", "=ds=#p12# (325)" },
        { 23155, "INV_Scroll_06", "=q2=Design: Lustrous Azure Moonstone", "=ds=#p12# (325)" },
        { 23150, "INV_Scroll_06", "=q2=Design: Thick Golden Draenite", "=ds=#p12# (315)" },
        { 22552, "INV_Scroll_03", "=q1=Formula: Enchant Weapon - Major Striking", "=ds=#p4# (340)" },
        { 25908, "INV_Scroll_03", "=q1=Design: Swift Skyfire Diamond", "=ds=#p12# (365)" },
        { 25902, "INV_Scroll_03", "=q1=Design: Powerful Earthstorm Diamond", "=ds=#p12# (365) (#z12#)" },
        { 24314, "INV_Scroll_03", "=q1=Pattern: Bag of Jewels", "=ds=#p8# (340)" },
        };
        
    Consortium2 = {
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r4#", "" },
        { 29117, "INV_Chest_Cloth_08", "=q3=Stormspire Vest", "=ds=#s5#, #a1#" },
        { 29116, "INV_Pants_02", "=q3=Nomad's Leggings", "=ds=#s11#, #a2#" },
        { 29115, "INV_Weapon_Rifle_07", "=q3=Consortium Blaster", "=ds=#w5#" },
        { 24178, "INV_Scroll_05", "=q3=Design: Pendant of the Null Rune", "=ds=#p12# (360)" },
        { 33156, "INV_Scroll_05", "=q3=Design: Crimson Sun", "=ds=#p12# (360) (Patch 2.2)" },
        { 33305, "INV_Scroll_05", "=q3=Design: Don Julio's Heart", "=ds=#p12# (360) (Patch 2.2)" },
        { 25734, "INV_Scroll_05", "=q3=Pattern: Fel Leather Leggings", "=ds=#p7# (350)" },
        { 22535, "INV_Misc_Note_01", "=q1=Formula: Enchant Ring - Weapon Might", "=ds=#p4# (360) (#z12#)" },
        { 23874, "INV_Scroll_03", "=q1=Schematic: Elemental Seaforium Charge", "=ds=#p5# (350)" },
        { 25903, "INV_Scroll_03", "=q1=Design: Bracing Earthstorm Diamond", "=ds=#p12# (365) (#z12#)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Weapon_Shortblade_31", "=q6=#r5#", "" },
        { 29122, "INV_Helmet_30", "=q4=Nether Runner's Cowl", "=ds=#s1#, #a1#" },
        { 29119, "INV_Jewelry_Necklace_29Naxxramas", "=q4=Haramad's Bargain", "=ds=#s2#" },
        { 29121, "INV_Weapon_Shortblade_31", "=q4=Guile of Khoraazi", "=ds=#h1#, #w4#" },
        { 32412, "INV_Scroll_05", "=q3=Design: Relentless Earthstorm Diamond", "=ds=#p12# (365)" },
        { 31776, "INV_Shirt_GuildTabard_01", "=q1=Consortium Tabard", "=ds=#s7#" },
        };

    Darkmoon1 = {
        { 19491, "INV_Jewelry_Necklace_14", "=q4=Amulet of the Darkmoon", "=ds=#s2#", "", "1200", "#darkmoon#"},   
        { 19426, "INV_Jewelry_Necklace_16", "=q4=Orb of the Darkmoon", "=ds=#s2#", "", "1200", "#darkmoon#"},
        { 19296, "INV_Misc_Bag_21", "=q2=Greater Darkmoon Prize", "", "", "40", "#darkmoon#" },
        { 19297, "INV_Misc_Bag_07_Black", "=q2=Lesser Darkmoon Prize", "", "", "12", "#darkmoon#" },
        { 19298, "INV_Misc_Bag_04", "=q2=Minor Darkmoon Prize", "", "", "5", "#darkmoon#" },
        { 19291, "INV_Box_04", "=q1=Darkmoon Storage Box", "", "", "50", "#darkmoon#" },
        { 19293, "INV_Misc_Food_18", "=q1=Last Year's Mutton", "=ds=#h1#, #w6#", "", "50", "#darkmoon#" },
        { 22729, "INV_Scroll_03", "=q1=Schematic: Steam Tonk Controller", "=ds=#p5# (275)", "", "40", "#darkmoon#" },
        { 19292, "INV_Misc_Food_18", "=q1=Last Month's Mutton", "=ds=#h1#, #w6#", "", "10", "#darkmoon#" },
        { 19295, "INV_Misc_Herb_19", "=q1=Darkmoon Flower", "=ds=#s15#", "", "5", "#darkmoon#" },
        { 0, "", "", "" },
        { 19182, "INV_Misc_Ticket_Darkmoon_01", "=q1=Darkmoon Faire Prize Ticket", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 19303, "INV_Jewelry_Necklace_11", "=q3=Darkmoon Necklace", "=ds=#s2#" },
        { 19302, "INV_Jewelry_Ring_34", "=q3=Darkmoon Ring", "=ds=#s13#" },
        { 0, "", "", "" },
        { 11026, "INV_Crate_02", "=q1=Tree Frog Box", "=ds=#e13#" },
        { 11027, "INV_Crate_02", "=q1=Wood Frog Box", "=ds=#e13#" },
        { 19450, "INV_Egg_04", "=q1=A Jubling's Tiny Home", "=q1=#m4#: =ds=#e13#" }, 
        };

    Darkmoon2 = {
        { 19228, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Beasts Deck", "=ds=#m2#" },
        { 19288, "INV_Misc_Ticket_Tarot_BlueDragon_01", "=q4=Darkmoon Card: Blue Dragon", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19267, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Elementals Deck", "=ds=#m2#" },
        { 19289, "INV_Misc_Ticket_Tarot_Maelstrom_01", "=q4=Darkmoon Card: Maelstrom", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19257, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Warlords Deck", "=ds=#m2#" },
        { 19287, "INV_Misc_Ticket_Tarot_Heroism_01", "=q4=Darkmoon Card: Heroism", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 19277, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Portals Deck", "=ds=#m2#" },
        { 19290, "INV_Misc_Ticket_Tarot_TwistingNether_01", "=q4=Darkmoon Card: Twisting Nether", "=q1=#m4#: =ds=#s14#"},
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 31907, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Furies Deck", "=ds=#m2#" },
        { 31858, "INV_Misc_Ticket_Tarot_Vengeance", "=q4=Darkmoon Card: Vengeance", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31891, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Storms Deck", "=ds=#m2#" },
        { 31857, "INV_Misc_Ticket_Tarot_Wrath", "=q4=Darkmoon Card: Wrath", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31890, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Blessings Deck", "=ds=#m2#" },
        { 31856, "INV_Misc_Ticket_Tarot_Crusade", "=q4=Darkmoon Card: Crusade", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 31914, "INV_Misc_Ticket_Tarot_Stack_01", "=q4=Lunacy Deck", "=ds=#m2#" },
        { 31859, "INV_Misc_Ticket_Tarot_Madness", "=q4=Darkmoon Card: Madness", "=q1=#m4#: =ds=#s14#" },
        };

    Frostwolf1 = {
        { 17909, "INV_Jewelry_FrostwolfTrinket_05", "=q4=Frostwolf Insignia Rank 6", "=ds=#s14#, =q1=#r5#" },
        { 17908, "INV_Jewelry_FrostwolfTrinket_04", "=q3=Frostwolf Insignia Rank 5", "=ds=#s14#, =q1=#r5#" },
        { 17907, "INV_Jewelry_FrostwolfTrinket_03", "=q3=Frostwolf Insignia Rank 4", "=ds=#s14#, =q1=#r4#" },
        { 17906, "INV_Jewelry_FrostwolfTrinket_02", "=q2=Frostwolf Insignia Rank 3", "=ds=#s14#, =q1=#r3#" },
        { 17905, "INV_Jewelry_FrostwolfTrinket_01", "=q2=Frostwolf Insignia Rank 2", "=ds=#s14#, =q1=#r2#" },
        { 17690, "INV_Jewelry_FrostwolfTrinket_01", "=q2=Frostwolf Insignia Rank 1", "=ds=#s14#, =q1=#r1#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20648, "INV_Hammer_22", "=q3=Cold Forged Hammer", "=q1=#m4#: =ds=#h3#, #w6#" },
        { 19106, "INV_Spear_04", "=q3=Ice Barbed Spear", "=q1=#m4#: =ds=#w7#" },
        { 19108, "INV_Wand_01", "=q3=Wand of Biting Cold", "=q1=#m4#: =ds=#w12#" },
        { 19107, "INV_Weapon_Crossbow_07", "=q3=Bloodseeker", "=q1=#m4#: =ds=#w3#" },
        };

    GelkisClan1 = {
        { 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
        { 6773, "INV_Chest_Chain_07", "=q2=Gelkis Marauder Chain", "=q1=#m4#: =ds=#s5#, #a3#" },
        { 6774, "INV_Wand_03", "=q2=Uthek's Finger", "=q1=#m4#: =ds=#s15#" },
        };

    HonorHold1 = {
        { 0, "INV_BannerPVP_02", "=q6=#r2#", "" },
        { 29213, "INV_Scroll_05", "=q3=Pattern: Felstalker Belt", "=ds=#p7# (350)" },
        { 23142, "INV_Scroll_06", "=q2=Design: Enduring Deep Peridot", "=ds=#p12# (315)" },
        { 22531, "INV_Misc_Note_01", "=q1=Formula: Enchant Bracer - Superior Healing", "=ds=#p4# (325)" },
        { 24007, "INV_Drink_Waterskin_05", "=q1=Footman's Waterskin", "=ds=#e4#" },
        { 24008, "INV_Mushroom_01", "=q1=Dried Mushroom Rations", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_02", "=q6=#r3#", "" },
        { 25826, "INV_Jewelry_Ring_11", "=q3=Sage's Band", "=ds=#s13#" },
        { 25825, "INV_Sword_20", "=q3=Footman's Longsword", "=ds=#h1#, #w10#" },
        { 29214, "INV_Scroll_05", "=q3=Pattern: Felstalker Bracers", "=ds=#p7# (360)" },
        { 29215, "INV_Scroll_05", "=q3=Pattern: Felstalker Breastplate", "=ds=#p7# (360)" },
        { 29196, "Spell_Fire_SealOfFire", "=q2=Glyph of Fire Warding", "=ds=#s1# #e17#" },
        { 25870, "INV_Scroll_03", "=q1=Recipe: Transmute Skyfire Diamond", "=ds=#p1# (350)" },
        { 22905, "INV_Scroll_03", "=q1=Recipe: Elixir of Major Agility", "=ds=#p1# (330)" },
        { 29719, "INV_Scroll_03", "=q1=Pattern: Cobrahide Leg Armor", "=ds=#p7# (335)" },
        };
        
    HonorHold2 = {
        { 0, "INV_BannerPVP_02", "=q6=#r4#", "" },
        { 29169, "INV_Jewelry_Ring_43", "=q3=Ring of Convalescence", "=ds=#s13#" },
        { 29166, "INV_Weapon_Halberd_12", "=q3=Hellforged Halberd", "=ds=#w7#" },
        { 32883, "INV_Misc_Ammo_Bullet_02", "=q3=Felbane Slugs", "=ds=#w18#" },
        { 24180, "INV_Scroll_05", "=q3=Design: Dawnstone Crab", "=ds=#p12# (370)" },
        { 29189, "Spell_Holy_HealingAura", "=q2=Glyph of Renewal", "=ds=#s1# #e17#" },
        { 22547, "INV_Misc_Note_01", "=q1=Formula: Enchant Chest - Exceptional Stats", "=ds=#p4# (345)" },
        { 30622, "INV_Misc_Key_13", "=q1=Flamewrought Key", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_02", "=q6=#r5#", "" },
        { 29153, "INV_Weapon_ShortBlade_12", "=q4=Blade of the Archmage", "=ds=#h3#, #w10#" },
        { 29156, "INV_Sword_11", "=q4=Honor's Call", "=ds=#h1#, #w10#" },
        { 29151, "INV_Weapon_Rifle_02", "=q4=Veteran's Musket", "=ds=#w5#" },
        { 33150, "INV_Misc_Note_01", "=q3=Formula: Enchant Cloak - Subtlety", "=ds=#p4# (300) (Patch 2.2)" },
        { 23619, "INV_Scroll_03", "=q1=Plans: Felsteel Shield Spike", "=ds=#p2# (360)" },
        { 29722, "INV_Scroll_03", "=q1=Pattern: Nethercobra Leg Armor", "=ds=#p7# (365)" },
        { 23999, "INV_Shirt_GuildTabard_01", "=q1=Honor Hold Tabard", "=ds=#s7#" },
        };

    KeepersofTime1 = {
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r3#", "" },
        { 33160, "INV_Scroll_05", "=q3=Design: Facet of Eternity", "=ds=#p12# (360) (Patch 2.2)" },
        { 29198, "Spell_Frost_FrostArmor02", "=q2=Glyph of Frost Warding", "=ds=#s1# #e17#" },
        { 28272, "INV_Misc_Note_01", "=q2=Formula: Enchant Gloves - Major Spellpower", "=ds=#p4# (360)" },
        { 22536, "INV_Misc_Note_01", "=q1=Formula: Enchant Ring - Spellpower", "=ds=#p4# (360)" },
        { 25910, "INV_Scroll_03", "=q1=Design: Enigmatic Skyfire Diamond", "=ds=#p12# (365)" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r4#", "" },
        { 29184, "INV_Pants_Plate_10", "=q3=Timewarden's Leggings", "=ds=#s11#, #a4#" },
        { 29185, "INV_Sword_11", "=q3=Continuum Blade", "=ds=#h3#, #w10#" },
        { 24181, "INV_Scroll_05", "=q3=Design: Living Ruby Serpent", "=ds=#p12# (370)" },
        { 24174, "INV_Scroll_05", "=q3=Design: Pendant of Frozen Flame", "=ds=#p12# (360)" },
        { 33158, "INV_Scroll_05", "=q3=Design: Stone of Blades", "=ds=#p12# (360) (Patch 2.2)" },
        { 29186, "Ability_Warrior_VictoryRush", "=q2=Glyph of the Defender", "=ds=#s1# #e17#" },
        { 30635, "INV_Misc_Key_04", "=q1=Key of Time", "=ds=#e9#" },
        { 0, "Ability_Warrior_VictoryRush", "=q6=#r5#", "" },
        { 29183, "INV_Bracer_10", "=q4=Bindings of the Timewalker", "=ds=#s8#, #a1#" },
        { 29181, "INV_DataCrystal02", "=q4=Timelapse Shard", "=ds=#s14#" },
        { 29182, "INV_Weapon_ShortBlade_26", "=q4=Riftmaker", "=ds=#h1#, #w4#" },
        { 33152, "INV_Misc_Note_01", "=q3=Formula: Enchant Gloves - Superior Agility", "=ds=#p4# (300) (Patch 2.2)" },
        { 29713, "INV_Scroll_05", "=q3=Pattern: Drums of Panic", "=ds=#p7# (370)" },
        { 31355, "INV_Scroll_06", "=q2=Recipe: Flask of Supreme Power", "=ds=#p1# (300)" },
        };

    Kurenai1 = {
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
        { 29217, "INV_Scroll_05", "=q3=Pattern: Netherfury Belt", "=ds=#p7# (340)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
        { 29144, "INV_Misc_Quiver_06", "=q3=Worg Hide Quiver", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
        { 29219, "INV_Scroll_05", "=q3=Pattern: Netherfury Leggings", "=ds=#p7# (340)" },
        { 30444, "INV_Scroll_03", "=q1=Pattern: Reinforced Mining Bag", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
        { 29148, "Inv_Shoulder_25", "=q3=Blackened Leather Spaulders", "=ds=#s3#, #a2#" },
        { 29142, "INV_Pants_Leather_14", "=q3=Kurenai Kilt", "=ds=#s11#, #a2#" },
        { 29146, "INV_Jewelry_Ring_35", "=q3=Band of Elemental Spirits", "=ds=#s13#" },
        { 29218, "INV_Scroll_05", "=q3=Pattern: Netherfury Boots", "=ds=#p7# (350)" },
        { 30443, "INV_Scroll_06", "=q2=Recipe: Transmute Primal Fire to Earth", "=ds=#p1# (350)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
        { 29227, "INV_Misc_Foot_Centaur", "=q4=Reins of the Cobalt War Talbuk", "=ds=#e12#" },
        { 29229, "INV_Misc_Foot_Centaur", "=q4=Reins of the Silver War Talbuk", "=ds=#e12#" },
        { 29230, "INV_Misc_Foot_Centaur", "=q4=Reins of the Tan War Talbuk", "=ds=#e12#" },
        { 29231, "INV_Misc_Foot_Centaur", "=q4=Reins of the White War Talbuk", "=ds=#e12#" },
        { 31830, "INV_Misc_Foot_Centaur", "=q4=Reins of the Cobalt Riding Talbuk", "=ds=#e12#" },
        { 31832, "INV_Misc_Foot_Centaur", "=q4=Reins of the Silver Riding Talbuk", "=ds=#e12#" },
        { 31834, "INV_Misc_Foot_Centaur", "=q4=Reins of the Tan Riding Talbuk", "=ds=#e12#" },
        { 31836, "INV_Misc_Foot_Centaur", "=q4=Reins of the White Riding Talbuk", "=ds=#e12#" },
        { 29140, "INV_Misc_Cape_19", "=q3=Cloak of the Ancient Spirits", "=ds=#s4#" },
        { 29136, "INV_Helmet_04", "=q3=Far Seer's Helm", "=ds=#s1#, #a3#" },
        { 29138, "INV_Mace_45", "=q3=Arechron's Gift", "=ds=#h2#, #w6#" },
        { 31774, "INV_Shirt_GuildTabard_01", "=q1=Kurenai Tabard", "=ds=#s7#" },
        };

    LowerCity1 = {
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r2#", "" },
        { 23138, "INV_Scroll_06", "=q2=Design: Potent Flame Spessarite", "=ds=#p12# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r4#", "" },
        { 30836, "INV_Pants_Cloth_09", "=q3=Leggings of the Skettis Exile", "=ds=#s11#, #a1#" },
        { 30835, "INV_Chest_Plate08", "=q3=Salvager's Hauberk", "=ds=#s5#, #a3#" },
        { 30841, "INV_Misc_Book_11", "=q3=Lower City Prayerbook", "=ds=#s14#" },
        { 24179, "INV_Scroll_05", "=q3=Design: Felsteel Boar", "=ds=#p12# (370)" },
        { 24175, "INV_Scroll_05", "=q3=Design: Pendant of Thawing", "=ds=#p12# (360)" },
        { 33157, "INV_scroll_05", "=q3=Design: Falling Star", "=ds=#p12# (360) (Patch 2.2)" },
        { 30846, "Ability_Rogue_MasterOfSubtlety", "=q2=Glyph of the Outcast", "=ds=#s1# #e17#" },
        { 22910, "INV_Scroll_06", "=q2=Recipe: Elixir of Major Shadow Power", "=ds=#p1# (350)" },
        { 30633, "INV_Misc_Key_11", "=q1=Auchenai Key", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r3#", "" },
        { 29199, "Spell_Shadow_SealOfKings", "=q2=Glyph of Shadow Warding", "=ds=#s1# #e17#" },
        { 30833, "INV_Scroll_03", "=q1=Pattern: Cloak of Arcane Evasion", "=ds=#p8# (350)" },
        { 0, "", "", "" },
        { 0, "Ability_Rogue_MasterOfSubtlety", "=q6=#r5#", "" },
        { 30834, "INV_Jewelry_Ring_41", "=q4=Shapeshifter's Signet", "=ds=#s13#" },
        { 30832, "INV_Hammer_08", "=q4=Gavel of Unearthed Secrets", "=ds=#h3#, #w6#" },
        { 30830, "INV_Spear_04", "=q4=Trident of the Outcast Tribe", "=ds=#w7#" },
        { 33148, "INV_Misc_Note_01", "=q3=Formula: Enchant Cloak - Dodge", "=ds=#p4# (300) (Patch 2.2)" },
        { 31357, "INV_Scroll_06", "=q2=Recipe: Flask of Chromatic Resistance", "=ds=#p1# (300)" },
        { 31778, "INV_Shirt_GuildTabard_01", "=q1=Lower City Tabard", "=ds=#s7#" },
        };

    Maghar1 = {
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r2#", "" },
        { 25741, "INV_Scroll_05", "=q3=Pattern: Netherfury Belt", "=ds=#p7# (340)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r3#", "" },
        { 29143, "INV_Misc_Quiver_08", "=q3=Clefthoof Hide Quiver", "=ds=#m14# #w19# =q1=#m1# =ds=#c2#" },
        { 25742, "INV_Scroll_05", "=q3=Pattern: Netherfury Leggings", "=ds=#p7# (340)" },
        { 29664, "INV_Scroll_03", "=q1=Pattern: Reinforced Mining Bag", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r4#", "" },
        { 29147, "INV_Shoulder_07", "=q3=Talbuk Hide Spaulders", "=ds=#s3#, #a2#" },
        { 29141, "INV_Pants_Leather_14", "=q3=Tempest Leggings", "=ds=#s11#, #a2#" },
        { 29145, "INV_Jewelry_Ring_15", "=q3=Band of Ancestral Spirits", "=ds=#s13#" },
        { 25743, "INV_Scroll_05", "=q3=Pattern: Netherfury Boots", "=ds=#p7# (350)" },
        { 22917, "INV_Scroll_06", "=q2=Recipe: Transmute Primal Fire to Earth", "=ds=#p1# (350)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Foot_Centaur", "=q6=#r5#", "" },
        { 29102, "INV_Misc_Foot_Centaur", "=q4=Reins of the Cobalt War Talbuk", "=ds=#e12#" },
        { 29104, "INV_Misc_Foot_Centaur", "=q4=Reins of the Silver War Talbuk", "=ds=#e12#" },
        { 29105, "INV_Misc_Foot_Centaur", "=q4=Reins of the Tan War Talbuk", "=ds=#e12#" },
        { 29103, "INV_Misc_Foot_Centaur", "=q4=Reins of the White War Talbuk", "=ds=#e12#" },
        { 31829, "INV_Misc_Foot_Centaur", "=q4=Reins of the Cobalt Riding Talbuk", "=ds=#e12#" },
        { 31831, "INV_Misc_Foot_Centaur", "=q4=Reins of the Silver Riding Talbuk", "=ds=#e12#" },
        { 31833, "INV_Misc_Foot_Centaur", "=q4=Reins of the Tan Riding Talbuk", "=ds=#e12#" },
        { 31835, "INV_Misc_Foot_Centaur", "=q4=Reins of the White Riding Talbuk", "=ds=#e12#" },
        { 29139, "INV_Misc_Cape_06", "=q3=Ceremonial Cover", "=ds=#s4#" },
        { 29135, "INV_Helmet_17", "=q3=Earthcaller's Headdress", "=ds=#s1#, #a3#" },
        { 29137, "INV_Axe_44", "=q3=Hellscream's Will", "=ds=#h2#, #w1#" },
        { 31773, "INV_Shirt_GuildTabard_01", "=q1=Mag'har Tabard", "=ds=#s7#" },
        };

    MagramClan1 = {
        { 0, "INV_Misc_Head_Centaur_01", "=q6=#r2#", "" },
        { 6789, "INV_Misc_Cape_12", "=q2=Ceremonial Centaur Blanket", "=q1=#m4#: =ds=#s4#" },
        { 6788, "INV_Belt_11", "=q2=Magram Hunter's Belt", "=q1=#m4#: =ds=#s10#, #a2#" },
        };

    Netherwing1 = {
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r2#", "" },
        { 32694, "INV_Misc_Gem_Sapphire_01", "=q2=Overseer's Badge", "=ds=#s14#" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r3#", "" },
        { 32695, "INV_Misc_Gem_Sapphire_01", "=q3=Captain's Badge", "=ds=#s14#" },
        { 32863, "INV_Misc_Crop_01", "=q3=Skybreaker Whip", "=q1=#m4#: =ds=#s14#" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r4#", "" },
        { 32864, "INV_Misc_Gem_Sapphire_01", "=q3=Commander's Badge", "=ds=#s14#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Mount_Netherdrakepurple", "=q6=#r5#", "" },
        { 32858, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Azure Netherwing Drake", "=ds=#e12#" },
        { 32859, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Cobalt Netherwing Drake", "=ds=#e12#" },
        { 32857, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Onyx Netherwing Drake", "=ds=#e12#" },
        { 32860, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Purple Netherwing Drake", "=ds=#e12#" },
        { 32861, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Veridian Netherwing Drake", "=ds=#e12#" },
        { 32862, "Ability_Mount_Netherdrakepurple", "=q4=Reins of the Violet Netherwing Drake", "=ds=#e12#" },
        };

    Ogrila1 = {
        { 0, "INV_DataCrystal01", "=q6=#r3#", "" },
        { 32784, "INV_Potion_52", "=q1=Red Ogre Brew", "=ds=#e4#", "", "2", "#ogrilashard#" },
        { 32783, "INV_Potion_73", "=q1=Blue Ogre Brew", "=ds=#e4#", "", "3", "#ogrilashard#" },
        { 0, "", "", "" },
        { 0, "INV_DataCrystal01", "=q6=#r4#", "" },
        { 32653, "INV_Misc_Cape_08", "=q3=Apexis Cloak", "=ds=#s4#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32654, "INV_DataCrystal01", "=q3=Crystalforged Trinket", "=ds=#s14#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32652, "INV_Shield_30", "=q3=Ogri'la Aegis", "=ds=#w8#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 32650, "INV_Wand_14", "=q3=Cerulean Crystal Rod", "=ds=#w12#", "", "1", "#ogrilacrystal#", "50", "#ogrilashard#" },
        { 0, "", "", "" },
        { 32572, "INV_Misc_Apexis_Crystal", "=q3=Apexis Crystal", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_DataCrystal01", "=q6=#r5#", "" },
        { 32647, "INV_Bracer_13", "=q4=Shard-bound Bracers", "=ds=#s8#, #a2#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32648, "INV_Boots_Plate_02", "=q4=Vortex Walking Boots", "=ds=#s12#, #a4#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32651, "INV_Misc_Orb_04", "=q4=Crystal Orb of Enlightenment", "=ds=#s15#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32645, "INV_Weapon_Crossbow_14", "=q4=Crystalline Crossbow", "=ds=#w3#", "", "4", "#ogrilacrystal#", "100", "#ogrilashard#" },
        { 32828, "INV_Shirt_GuildTabard_01", "=q1=Ogri'la Tabard", "=ds=#s7#", "", "10", "#ogrilashard#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 32569, "INV_Misc_Apexis_Shard", "=q1=Apexis Shard", "=ds=#m17#" },
        };  

    Scryer1 = {
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r2#", "" },
        { 23133, "INV_Scroll_06", "=q2=Design: Runed Blood Garnet", "=ds=#p12# (315)" },
        { 23597, "INV_Scroll_03", "=q1=Plans: Enchanted Adamantite Belt", "=ds=#p2# (355)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r3#", "" },
        { 28907, "Ability_DualWield", "=q2=Inscription of the Blade", "=ds=#s3# #e17#" },
        { 28908, "Spell_Holy_ChampionsBond", "=q2=Inscription of the Knight", "=ds=#s3# #e17#" },
        { 28904, "Spell_Holy_SpiritualGuidence", "=q2=Inscription of the Oracle", "=ds=#s3# #e17#" },
        { 28903, "INV_Misc_Orb_04", "=q2=Inscription of the Orb", "=ds=#s3# #e17#" },
        { 23143, "INV_Scroll_06", "=q2=Design: Dazzling Deep Peridot", "=ds=#p12# (325)" },
        { 23598, "INV_Scroll_03", "=q1=Plans: Enchanted Adamantite Boots", "=ds=#p2# (355)" },
        { 29701, "INV_Scroll_03", "=q1=Pattern: Enchanted Clefthoof Boots", "=ds=#p7# (350)" },
        { 29682, "INV_Scroll_03", "=q1=Pattern: Enchanted Felscale Gloves", "=ds=#p7# (350)" },
        { 24292, "INV_Scroll_03", "=q1=Pattern: Mystic Spellthread", "=ds=#p8# (335)" },
        };

    ScaleSands1 = {
        { 29298, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
        { 29299, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
        { 29300, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
        { 29301, "INV_Jewelry_Ring_55", "=q4=Band of the Eternal Champion", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 29294, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
        { 29295, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
        { 29296, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
        { 29297, "INV_Jewelry_Ring_55", "=q4=Band of the Eternal Defender", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 29302, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
        { 29303, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
        { 29304, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
        { 29305, "INV_Jewelry_Ring_55", "=q4=Band of the Eternal Sage", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 29307, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r2#" },
        { 29306, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r3#" },
        { 29308, "INV_Jewelry_Ring_54", "=q4=Band of Eternity", "=ds=#s13#, =q1=#r4#" },
        { 29309, "INV_Jewelry_Ring_55", "=q4=Band of the Eternal Restorer", "=ds=#s13#, =q1=#r5#" },
        };

    ScaleSands2 = {
        { 0, "INV_Misc_MonsterScales_13", "=q6=#r2#", "" },
        { 32274, "INV_Scroll_04", "=q4=Design: Bold Crimson Spinel", "=ds=#p12# (375)" },
        { 32283, "INV_Scroll_04", "=q4=Design: Bright Crimson Spinel", "=ds=#p12# (375)" },
        { 32277, "INV_Scroll_04", "=q4=Design: Delicate Crimson Spinel", "=ds=#p12# (375)" },
        { 32282, "INV_Scroll_04", "=q4=Design: Runed Crimson Spinel", "=ds=#p12# (375)" },
        { 32284, "INV_Scroll_04", "=q4=Design: Subtle Crimson Spinel", "=ds=#p12# (375)" },
        { 32281, "INV_Scroll_04", "=q4=Design: Teardrop Crimson Spinel", "=ds=#p12# (375)" },
        { 32290, "INV_Scroll_04", "=q4=Design: Brilliant Lionseye", "=ds=#p12# (375)" },
        { 32291, "INV_Scroll_04", "=q4=Design: Gleaming Lionseye", "=ds=#p12# (375)" },
        { 32293, "INV_Scroll_04", "=q4=Design: Smooth Lionseye", "=ds=#p12# (375)" },
        { 32294, "INV_Scroll_04", "=q4=Design: Thick Lionseye", "=ds=#p12# (375)" },
        { 32288, "INV_Scroll_04", "=q4=Design: Lustrous Empyrean Sapphire", "=ds=#p12# (375)" },
        { 32286, "INV_Scroll_04", "=q4=Design: Solid Empyrean Sapphire", "=ds=#p12# (375)" },
        { 32287, "INV_Scroll_04", "=q4=Design: Sparkling Empyrean Sapphire", "=ds=#p12# (375)" },
        { 32300, "Inv_Scroll_04", "=q4=Design: Infused Shadowsong Amethyst", "=ds=#p12# (375)" },
        { 0, "INV_Misc_MonsterScales_13", "=q6=#r3#", "" },
        { 32299, "INV_Scroll_04", "=q4=Design: Balanced Shadowsong Amethyst", "=ds=#p12# (375)" },
        { 32301, "INV_Scroll_04", "=q4=Design: Glowing Shadowsong Amethyst", "=ds=#p12# (375)" },
        { 32311, "INV_Scroll_04", "=q4=Design: Dazzling Seaspray Emerald", "=ds=#p12# (375)" },
        { 32312, "INV_Scroll_04", "=q4=Design: Jagged Seaspray Emerald", "=ds=#p12# (375)" },
        { 32310, "INV_Scroll_04", "=q4=Design: Radiant Seaspray Emerald", "=ds=#p12# (375)" },
        { 32306, "INV_Scroll_04", "=q4=Design: Glinting Pyrestone", "=ds=#p12# (375)" },
        { 32305, "INV_Scroll_04", "=q4=Design: Luminous Pyrestone", "=ds=#p12# (375)" },
        { 32304, "INV_Scroll_04", "=q4=Design: Potent Pyrestone", "=ds=#p12# (375)" },
        { 31737, "INV_Misc_Ammo_Arrow_04", "=q4=Timeless Arrow", "=ds=#w17#" },
        { 31735, "INV_Misc_Ammo_Bullet_02", "=q4=Timeless Shell", "=ds=#w18#" },
        { 32302, "INV_Scroll_04", "=q4=Design: Royal Shadowsong Amethyst", "=ds=#p12# (375), #r4#" },
        { 32309, "INV_Scroll_04", "=q4=Design: Enduring Seaspray Emerald", "=ds=#p12# (375), #r4#" },
        { 32308, "INV_Scroll_04", "=q4=Design: Wicked Pyrestone", "=ds=#p12# (375), #r4#" },
        { 22538, "INV_Misc_Note_01", "=q1=Formula: Enchant Ring - Stats", "=ds=#p4# (375), #r4#" },
        };       

    Scryer2 = {      
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r4#", "" },
        { 29131, "INV_Pants_Leather_18", "=q3=Retainer's Leggings", "=ds=#s11#, #a2# " },
        { 29134, "INV_Gauntlets_26", "=q3=Gauntlets of the Chosen", "=ds=#s9#, #a4# " },
        { 29132, "INV_Misc_Gem_Bloodstone_02", "=q3=Scryer's Bloodgem", "=ds=#s14#" },
        { 29133, "INV_Staff_38", "=q3=Seer's Cane", "=ds=#w9#" },
        { 24176, "INV_Scroll_05", "=q3=Design: Pendant of Withering", "=ds=#p12# (360)" },
        { 22908, "INV_Scroll_06", "=q2=Recipe: Elixir of Major Firepower", "=ds=#p1# (345)" },
        { 23599, "INV_Scroll_03", "=q1=Plans: Enchanted Adamantite Breastplate", "=ds=#p2# (360)" },
        { 29700, "INV_Scroll_03", "=q1=Pattern: Enchanted Clefthoof Gloves", "=ds=#p7# (350)" },
        { 29684, "INV_Scroll_03", "=q1=Pattern: Enchanted Felscale Boots", "=ds=#p7# (350)" },
        { 25722, "INV_Scroll_03", "=q1=Pattern: Magister's Armor Kit", "=ds=#p7# (325)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Spell_Holy_ChampionsBond", "=q6=#r5#", "" },
        { 29126, "INV_Jewelry_Ring_52Naxxramas", "=q4=Seer's Signet", "=ds=#s13#" },
        { 29125, "INV_Weapon_Shortblade_29", "=q4=Retainer's Blade", "=ds=#h1#, #w4#" },
        { 28910, "Spell_Holy_WeaponMastery", "=q3=Greater Inscription of the Blade", "=ds=#s3# #e17#" },
        { 28911, "Spell_Holy_ChampionsGrace", "=q3=Greater Inscription of the Knight", "=ds=#s3# #e17#" },
        { 28912, "Spell_Holy_PowerInfusion", "=q3=Greater Inscription of the Oracle", "=ds=#s3# #e17#" },
        { 28909, "INV_Misc_Orb_03", "=q3=Greater Inscription of the Orb", "=ds=#s3# #e17#" },
        { 23600, "INV_Scroll_03", "=q1=Plans: Enchanted Adamantite Leggings", "=ds=#p2# (365)" },
        { 29698, "INV_Scroll_03", "=q1=Pattern: Enchanted Clefthoof Leggings", "=ds=#p7# (350)" },
        { 29677, "INV_Scroll_03", "=q1=Pattern: Enchanted Felscale Leggings", "=ds=#p7# (350)" },
        { 24294, "INV_Scroll_03", "=q1=Pattern: Runic Spellthread", "=ds=#p8# (375)" },
        { 31780, "INV_Shirt_GuildTabard_01", "=q1=Scryers Tabard", "=ds=#s7#" },
        };

    Shatar1 = {
        { 0, "Spell_Nature_LightningOverload", "=q6=#r2#", "" },
        { 25904, "INV_Scroll_03", "=q1=Design: Insightful Earthstorm Diamond", "=ds=#p12# (365)" },
        { 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r4#", "" },
        { 29180, "INV_Belt_08", "=q3=Blessed Scale Girdle", "=ds=#s10#, #a3#" },
        { 29179, "INV_Misc_ElvenCoins", "=q3=Xi'ri's Gift", "=ds=#s14#" },
        { 24182, "INV_Scroll_05", "=q3=Design: Talasite Owl", "=ds=#p12# (370)" },
        { 33159, "INV_scroll_05", "=q3=Design: Blood of Amber", "=ds=#p12# (360) (Patch 2.2)" },
        { 29191, "Spell_Nature_LightningOverload", "=q2=Glyph of Power", "=ds=#s1# #e17#" },
        { 22915, "INV_Scroll_06", "=q2=Recipe: Transmute Primal Air to Fire", "=ds=#p1# (350)" },
        { 28281, "INV_Misc_Note_01", "=q2=Formula: Enchant Weapon - Major Healing", "=ds=#p4# (350)" },
        { 13517, "INV_Scroll_03", "=q1=Recipe: Alchemist's Stone", "=ds=#p1# (350)" },
        { 22537, "INV_Misc_Note_01", "=q1=Formula: Enchant Ring - Healing Power", "=ds=#p4# (370)" },
        { 30634, "INV_Misc_Key_09", "=q1=Warpforged Key", "=ds=#e9#" },
	{ 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r3#", "" },
        { 30826, "INV_Scroll_05", "=q3=Design: Ring of Arcane Shielding", "=ds=#p12# (360)" },
        { 33155, "INV_scroll_05", "=q3=Design: Kailee's Rose", "=ds=#p12# (360) (Patch 2.2)" },
        { 29195, "Spell_Arcane_ArcaneResilience", "=q2=Glyph of Arcane Warding", "=ds=#s1# #e17#" },
        { 28273, "INV_Misc_Note_01", "=q2=Formula: Enchant Gloves - Major Healing", "=ds=#p4# (350)" },
        { 0, "", "", "" },
        { 0, "Spell_Nature_LightningOverload", "=q6=#r5#", "" },
        { 29177, "INV_Jewelry_Ring_48Naxxramas", "=q4=A'dal's Command", "=ds=#s13#" },
        { 29175, "INV_Hammer_04", "=q4=Gavel of Pure Light", "=ds=#h3#, #w6#" },
        { 29176, "INV_Shield_30", "=q4=Crest of the Sha'tar", "=ds=#w8#" },
        { 33153, "INV_misc_note_01", "=q3=Formula: Enchant Gloves - Threat", "=ds=#p4# (300) (Patch 2.2)" },
        { 29717, "INV_Scroll_05", "=q3=Pattern: Drums of Battle", "=ds=#p7# (365)" },
        { 31354, "INV_Scroll_06", "=q2=Recipe: Flask of the Titans", "=ds=#p1# (300)" },
        { 31781, "INV_Shirt_GuildTabard_01", "=q1=Sha'tar Tabard", "=ds=#s7#" },
        };

    Skyguard1 = {
        { 0, "INV_Misc_Ribbon_01", "=q6=#r2#", "" },
        { 32722, "INV_Drink_09", "=q1=Enriched Terocone Juice", "=ds=#e4#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r3#", "" }, 
        { 32721, "INV_Misc_Food_63", "=q1=Skyguard Rations", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r4#", "" },
        { 32539, "INV_Misc_Cape_08", "=q3=Skyguard's Drape", "=ds=#s4#" },
        { 32538, "INV_Misc_Cape_05", "=q3=Skywitch's Drape", "=ds=#s4#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Ribbon_01", "=q6=#r5#", "" },
        { 32770, "INV_Jewelry_Talisman_06", "=q4=Skyguard Silver Cross", "=ds=#s14#" },
        { 32771, "INV_Misc_Ribbon_01", "=q4=Airman's Ribbon of Gallantry", "=ds=#s14#" },
        { 32319, "Ability_Hunter_Pet_NetherRay", "=q4=Blue Riding Nether Ray", "=ds=#e12#" },
        { 32314, "Ability_Hunter_Pet_NetherRay", "=q4=Green Riding Nether Ray", "=ds=#e12#" },
        { 32317, "Ability_Hunter_Pet_NetherRay", "=q4=Red Riding Nether Ray", "=ds=#e12#" },
        { 32316, "Ability_Hunter_Pet_NetherRay", "=q4=Purple Riding Nether Ray", "=ds=#e12#" },
        { 32318, "Ability_Hunter_Pet_NetherRay", "=q4=Silver Riding Nether Ray", "=ds=#e12#" },
        { 32445, "INV_Shirt_GuildTabard_01", "=q1=Skyguard Tabard", "=ds=#s7#" },
        };  

    Sporeggar1 = {
        { 0, "INV_Mushroom_10", "=q6=#r2#", "" },
        { 27689, "INV_Scroll_03", "=q1=Recipe: Sporeling Snack", "=ds=#p3# (310)", "", "2", "#glowcap#" },
        { 30156, "INV_Scroll_03", "=q1=Recipe: Clam Bar", "=ds=#p3# (300)", "", "1", "#glowcap#" },
        { 25548, "INV_Mushroom_10", "=q1=Tallstalk Mushroom", "=ds=#e3#", "", "1", "#glowcap#" },
        { 24539, "INV_Mushroom_01", "=q1=Marsh Lichen", "=ds=#e3#", "", "2", "#glowcap#" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r3#", "" },
        { 25827, "INV_Misc_Cape_17", "=q3=Muck-Covered Drape", "=ds=#s4#", "", "25", "#glowcap#" },
        { 25828, "INV_Shield_21", "=q3=Petrified Lichen Guard", "=ds=#w8#", "", "15", "#glowcap#" },
        { 25550, "INV_Mushroom_07", "=q1=Redcap Toadstool", "=ds=#e3#", "", "1", "#glowcap#" },
        { 0, "", "", "" },
        { 24245, "INV_Mushroom_02", "=q1=Glowcap", "=ds=#m17#", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r4#", "" },
        { 29150, "INV_Weapon_ShortBlade_08", "=q3=Hardened Stone Shard", "=ds=#h1#, #w4#", "", "45", "#glowcap#" },
        { 29149, "INV_Staff_02", "=q3=Sporeling's Firestick", "=ds=#w12#", "", "20", "#glowcap#" },
        { 22916, "INV_Scroll_06", "=q2=Recipe: Transmute Primal Earth to Water", "=ds=#p1# (350)", "", "25", "#glowcap#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Mushroom_10", "=q6=#r5#", "" },
        { 22906, "INV_Scroll_06", "=q2=Recipe: Shrouding Potion", "=ds=#p1# (335)", "", "30", "#glowcap#" },
        { 31775, "INV_Shirt_GuildTabard_01", "=q1=Sporeggar Tabard", "=ds=#s7#" },
        };

    Stormpike1 = {
        { 17904, "INV_Jewelry_StormPikeTrinket_05", "=q4=Stormpike Insignia Rank 6", "=ds=#s14#, =q1=#r5#" },
        { 17903, "INV_Jewelry_StormPikeTrinket_04", "=q3=Stormpike Insignia Rank 5", "=ds=#s14#, =q1=#r5#" },
        { 17902, "INV_Jewelry_StormPikeTrinket_03", "=q3=Stormpike Insignia Rank 4", "=ds=#s14#, =q1=#r4#" },
        { 17901, "INV_Jewelry_StormPikeTrinket_02", "=q2=Stormpike Insignia Rank 3", "=ds=#s14#, =q1=#r3#" },
        { 17900, "INV_Jewelry_StormPikeTrinket_01", "=q2=Stormpike Insignia Rank 2", "=ds=#s14#, =q1=#r2#" },
        { 17691, "INV_Jewelry_StormPikeTrinket_01", "=q2=Stormpike Insignia Rank 1", "=ds=#s14#, =q1=#r1#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 20648, "INV_Hammer_22", "=q3=Cold Forged Hammer", "=q1=#m4#: =ds=#h3#, #w6#" },
        { 19106, "INV_Spear_04", "=q3=Ice Barbed Spear", "=q1=#m4#: =ds=#w7#" },
        { 19108, "INV_Wand_01", "=q3=Wand of Biting Cold", "=q1=#m4#: =ds=#w12#" },
        { 19107, "INV_Weapon_Crossbow_07", "=q3=Bloodseeker", "=q1=#m4#: =ds=#w3#" },
        }; 

    Thorium1 = {
        { 0, "INV_Ingot_Mithril", "=q6=#r2#", "" },
        { 17051, "INV_Scroll_03", "=q3=Plans: Dark Iron Bracers", "=ds=#p2# (295)" },
        { 20761, "INV_Scroll_03", "=q1=Recipe: Transmute Elemental Fire", "=ds=#p1# (300)" },
        { 19444, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Strength", "=ds=#p4# (290)" },
        { 17023, "INV_Scroll_03", "=q1=Pattern: Molten Helm", "=ds=#p7# (300)" },
        { 17022, "INV_Scroll_03", "=q1=Pattern: Corehound Boots", "=ds=#p7# (295)" },
        { 17018, "INV_Scroll_03", "=q1=Pattern: Flarecore Gloves", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Ingot_Mithril", "=q6=#r3#", "" },
        { 17060, "INV_Scroll_03", "=q3=Plans: Dark Iron Destroyer", "=ds=#p2# (300)" },
        { 17059, "INV_Scroll_03", "=q3=Plans: Dark Iron Reaver", "=ds=#p2# (300)" },
        { 17049, "INV_Scroll_03", "=q3=Plans: Fiery Chain Girdle", "=ds=#p2# (295)" },
        { 19206, "INV_Scroll_03", "=q1=Plans: Dark Iron Helm", "=ds=#p2# (300)" },
        { 19448, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Mighty Spirit", "=ds=#p4# (300)" },  
        { 17025, "INV_Scroll_03", "=q1=Pattern: Black Dragonscale Boots", "=ds=#p7# (300)" },
        { 19330, "INV_Scroll_03", "=q1=Pattern: Lava Belt", "=ds=#p7# (300)" },
        { 17017, "INV_Scroll_03", "=q1=Pattern: Flarecore Mantle", "=ds=#p8# (300)" },
        { 19219, "INV_Scroll_03", "=q1=Pattern: Flarecore Robe", "=ds=#p8# (300)" },
        };
    
    Thorium2 = {
        { 0, "INV_Ingot_Mithril", "=q6=#r4#", "" },
        { 18592, "INV_Scroll_03", "=q4=Plans: Sulfuron Hammer", "=ds=#p2# (300), #m4#" },
        { 17052, "INV_Scroll_03", "=q3=Plans: Dark Iron Leggings", "=ds=#p2# (300)" },
        { 17053, "INV_Scroll_03", "=q3=Plans: Fiery Chain Shoulders", "=ds=#p2# (300)" },
        { 19209, "INV_Scroll_03", "=q1=Plans: Blackfury", "=ds=#p2# (300)" },  
        { 19208, "INV_Scroll_03", "=q1=Plans: Black Amnesty", "=ds=#p2# (300)" },
        { 19207, "INV_Scroll_03", "=q1=Plans: Dark Iron Gauntlets", "=ds=#p2# (300)" },
        { 19449, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Mighty Intellect", "=ds=#p4# (300)" }, 
        { 19331, "INV_Scroll_03", "=q1=Pattern: Chromatic Gauntlets", "=ds=#p7# (300)" },
        { 19332, "INV_Scroll_03", "=q1=Pattern: Corehound Belt", "=ds=#p7# (300)" }, 
        { 19333, "INV_Scroll_03", "=q1=Pattern: Molten Belt", "=ds=#p7# (300)" },
        { 19220, "INV_Scroll_03", "=q1=Pattern: Flarecore Leggings", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Ingot_Mithril", "=q6=#r5#", "" },
        { 19211, "INV_Scroll_03", "=q1=Plans: Blackguard", "=ds=#p2# (300)" },
        { 20040, "INV_Scroll_03", "=q1=Plans: Dark Iron Boots", "=ds=#p2# (300)" },    
        { 19210, "INV_Scroll_03", "=q1=Plans: Ebon Hand", "=ds=#p2# (300)" },  
        { 19212, "INV_Scroll_03", "=q1=Plans: Nightfall", "=ds=#p2# (300)" },
        }; 

    Thrallmar1 = {
        { 0, "INV_BannerPVP_01", "=q6=#r2#", "" },
        { 25738, "INV_Scroll_05", "=q3=Pattern: Felstalker Belt", "=ds=#p7# (350)" },
        { 31359, "INV_Scroll_06", "=q2=Design: Enduring Deep Peridot", "=ds=#p12# (315)" },
        { 24000, "INV_Misc_Note_01", "=q1=Formula: Enchant Bracer - Superior Healing", "=ds=#p4# (325)" },
        { 24006, "INV_Drink_Waterskin_05", "=q1=Grunt's Waterskin", "=ds=#e4#" },
        { 24009, "INV_Misc_Food_42", "=q1=Dried Fruit Rations", "=ds=#e3#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_01", "=q6=#r3#", "" },
        { 25824, "INV_Jewelry_Ring_17", "=q3=Farseer's Band", "=ds=#s13#" },
        { 25823, "INV_Axe_11", "=q3=Grunt's Waraxe", "=ds=#h1#, #w1#" },
        { 25739, "INV_Scroll_05", "=q3=Pattern: Felstalker Bracers", "=ds=#p7# (360)" },
        { 25740, "INV_Scroll_05", "=q3=Pattern: Felstalker Breastplate", "=ds=#p7# (360)" },
        { 29197, "Spell_Fire_SealOfFire", "=q2=Glyph of Fire Warding", "=ds=#s1# #e17#" },
        { 29232, "INV_Scroll_03", "=q1=Recipe: Transmute Skyfire Diamond", "=ds=#p1# (350)" },
        { 24001, "INV_Scroll_03", "=q1=Recipe: Elixir of Major Agility", "=ds=#p1# (330)" },
        { 31361, "INV_Scroll_03", "=q1=Pattern: Cobrahide Leg Armor", "=ds=#p7# (335)" },
        };
        
    Thrallmar2 = {
        { 0, "INV_BannerPVP_01", "=q6=#r4#", "" },
        { 29168, "INV_Jewelry_Ring_22", "=q3=Ancestral Band", "=ds=#s13#" },
        { 29167, "INV_Spear_03", "=q3=Blackened Spear", "=ds=#w7#" },
        { 32882, "INV_Misc_Ammo_Bullet_02", "=q3=Hellfire Shot", "=ds=#w18#" },
        { 31358, "INV_Scroll_05", "=q3=Design: Dawnstone Crab", "=ds=#p12# (370)" },
        { 29190, "Spell_Holy_HealingAura", "=q2=Glyph of Renewal", "=ds=#s1# #e17#" },
        { 24003, "INV_Misc_Note_01", "=q1=Formula: Enchant Chest - Exceptional Stats", "=ds=#p4# (345)" },
        { 30637, "INV_Misc_Key_13", "=q1=Flamewrought Key", "=ds=#e9#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_BannerPVP_01", "=q6=#r5#", "" },
        { 29155, "INV_Weapon_ShortBlade_27", "=q4=Stormcaller", "=ds=#h3#, #w10#" },
        { 29165, "INV_Axe_10", "=q4=Warbringer", "=ds=#h1#, #w1#" },
        { 29152, "INV_Weapon_Bow_08", "=q4=Marksman's Bow", "=ds=#w2#" },
	{ 33151, "INV_Misc_Note_01", "=q3=Formula: Enchant Cloak - Subtlety", "=ds=#p4# (300) (Patch 2.2)" }, 
        { 24002, "INV_Scroll_03", "=q1=Plans: Felsteel Shield Spike", "=ds=#p2# (360)" },
        { 31362, "INV_Scroll_03", "=q1=Pattern: Nethercobra Leg Armor", "=ds=#p7# (365)" },
        { 24004, "INV_Shirt_GuildTabard_01", "=q1=Thrallmar Tabard", "=ds=#s7#" },
        }; 

    Timbermaw = {
        { 0, "INV_Misc_Horn_01", "=q6=#r2#", "" },
        { 13484, "INV_Scroll_03", "=q2=Recipe: Transmute Earth to Water","=ds=#p1# (275)" },
        { 22392, "INV_Misc_Note_01", "=q1=Formula: Enchant 2H Weapon - Agility","=ds=#p4# (290)" },
        { 20254, "INV_Scroll_03", "=q1=Pattern: Warbear Woolies","=ds=#p7# (285)" },   		 
   	{ 20253, "INV_Scroll_03", "=q1=Pattern: Warbear Harness","=ds=#p7# (275)" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r3#", "" },
        { 16768, "INV_Misc_Bag_11", "=q2=Furbolg Medicine Pouch", "=ds=#s15#" },
        { 16769, "INV_Mace_11", "=q2=Furbolg Medicine Totem", "=ds=#h3#, #w6#" },
        { 19202, "INV_Scroll_03", "=q1=Plans: Heavy Timbermaw Belt","=ds=#p2# (290)" },
        { 19445, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Agility","=ds=#p4# (290)" },
        { 19326, "INV_Scroll_03", "=q1=Pattern: Might of the Timbermaw","=ds=#p7# (290)" },
        { 19215, "INV_Scroll_03", "=q1=Pattern: Wisdom of the Timbermaw","=ds=#p8# (290)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r4#", "" },
        { 19204, "INV_Scroll_03", "=q1=Plans: Heavy Timbermaw Boots","=ds=#p2# (300)" },
        { 19327, "INV_Scroll_03", "=q1=Pattern: Timbermaw Brawlers","=ds=#p7# (300)" },  
   	{ 19218, "INV_Scroll_03", "=q1=Pattern: Mantle of the Timbermaw","=ds=#p8# (300)" },  
   	{ 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Horn_01", "=q6=#r5#", "" },        
        { 21326, "INV_Misc_Horn_01", "=q4=Defender of the Timbermaw", "=q1=#m4#: =ds=#s14#"},
        };
     
    Tranquillien1 = {
        { 0, "INV_Misc_Bandana_03", "=q6=#r2#", "" },
        { 22991, "INV_Boots_Cloth_05", "=q2=Apprentice Boots", "=ds=#s12#, #a1# " },
        { 22992, "INV_Boots_04", "=q2=Bogwalker Boots", "=ds=#s12#, #a2# " },
        { 22993, "INV_Boots_01", "=q2=Volunteer's Greaves", "=ds=#s12#, #a3# " },
        { 28164, "INV_Sword_07", "=q2=Tranquillien Flamberge", "=ds=#h2#, #w10#" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r3#", "" },
        { 28155, "INV_Misc_Bandana_03", "=q2=Apothecary's Waistband", "=ds=#s10#, #a1# " },
        { 28158, "INV_Belt_09", "=q2=Batskin Belt", "=ds=#s10#, #a2# " },
        { 28162, "INV_Belt_03", "=q2=Tranquillien Defender's Girdle", "=ds=#s10#, #a3# " },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r4#", "" },
        { 22986, "INV_Chest_Cloth_19", "=q2=Apothecary's Robe", "=ds=#s5#, #a1# " },
        { 22987, "INV_Chest_Leather_01", "=q2=Deathstalker's Vest", "=ds=#s5#, #a2# " },
        { 22985, "INV_Chest_Chain", "=q2=Suncrown Hauberk", "=ds=#s5#, #a3# " },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Bandana_03", "=q6=#r5#", "" },
        { 22990, "INV_Misc_Cape_07", "=q3=Tranquillien Champion's Cloak", "=ds=#s4#" },
        };
    
    VioletEye1 = {
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Assassin"], "" },
        { 29280, "INV_Jewelry_Ring_62", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
        { 29281, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
        { 29282, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
        { 29283, "INV_Jewelry_Ring_62", "=q4=Violet Signet of the Master Assassin", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Mage"], "" },
        { 29284, "INV_Jewelry_Ring_62", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
        { 29285, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
        { 29286, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
        { 29287, "INV_Jewelry_Ring_62", "=q4=Violet Signet of the Archmage", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Restorer"], "" },
        { 29288, "INV_Jewelry_Ring_62", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
        { 29289, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
        { 29291, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
        { 29290, "INV_Jewelry_Ring_62", "=q4=Violet Signet of the Grand Restorer", "=ds=#s13#, =q1=#r5#" },
        { 0, "", "", "" },
        { 0, "INV_Jewelry_Ring_62", "=q6="..AL["Path of the Violet Protector"], "" },
        { 29276, "INV_Jewelry_Ring_62", "=q3=Violet Signet", "=ds=#s13#, =q1=#r2#" },
        { 29277, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r3#" },
        { 29278, "INV_Jewelry_Ring_62", "=q4=Violet Signet", "=ds=#s13#, =q1=#r4#" },
        { 29279, "INV_Jewelry_Ring_62", "=q4=Violet Signet of the Great Protector", "=ds=#s13#, =q1=#r5#" },
        };

    VioletEye2 = {
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r3#", "" },
        { 31113, "Spell_Holy_MindSooth", "=q4=Violet Badge", "=q1=#m4#: =ds=#s14#" },
        { 31395, "INV_Scroll_04", "=q4=Plans: Iceguard Helm", "=ds=#p2# (375)" },
        { 31393, "INV_Scroll_04", "=q4=Plans: Iceguard Breastplate", "=ds=#p2# (375)" },
        { 31401, "INV_Scroll_04", "=q4=Design: The Frozen Eye", "=ds=#p12# (375)" },
        { 29187, "Ability_Warrior_ShieldMastery", "=q2=Inscription of Endurance", "=ds=#s3# #e17#" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r4#", "" },
        { 31394, "INV_Scroll_04", "=q4=Plans: Iceguard Leggings", "=ds=#p2# (375)" },
        { 33205, "INV_Scroll_04", "=q4=Pattern: Shadowprowler's Chestguard", "=ds=#p7# (365) (Patch 2.2)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "Ability_Warrior_ShieldMastery", "=q6=#r5#", "" },
        { 33124, "INV_Scroll_05", "=q3=Pattern: Cloak of Darkness", "=ds=#p7# (360) (Patch 2.2)" },
        { 33209, "INV_Scroll_06", "=q2=Recipe: Flask of Chromatic Wonder", "=ds=#p1# (375) (Patch 2.2)" },
        { 33165, "INV_Misc_Note_01", "=q1=Formula: Enchant Weapon - Greater Agility", "=ds=#p4# (350) (Patch 2.2)" },
        };

    WaterLords1 = {
        { 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r3#", "" },
        { 18399, "INV_Jewelry_Ring_28", "=q3=Ocean's Breeze", "=q1=#m4#: =ds=#s13#" },
        { 18398, "INV_Jewelry_Ring_10", "=q3=Tidal Loop", "=q1=#m4#: =ds=#s13#" },
        { 17333, "INV_Potion_76", "=q1=Aqual Quintessence", "=ds=#m3#" },
        { 0, "", "", "" },
        { 0, "Spell_Frost_SummonWaterElemental_2", "=q6=#r4#", "" },
        { 22754, "INV_Potion_83", "=q1=Eternal Quintessence", "=ds=#m3#" },
        };

    Wintersaber1 = {
        { 0, "Ability_Mount_PinkTiger", "=q6=#r5#", "" },
        { 13086, "Ability_Mount_PinkTiger", "=q4=Reins of the Winterspring Frostsaber", "=ds=#e12#" },
        };

    Zandalar1 = {
        { 0, "INV_Misc_Coin_08", "=q6=#r2#", "" },
        { 20012, "INV_Scroll_03", "=q1=Recipe: Greater Dreamless Sleep", "=ds=#p1# (275)" },
        { 19778, "INV_Scroll_03", "=q1=Plans: Bloodsoul Gauntlets", "=ds=#p2# (300)" },
        { 19781, "INV_Scroll_03", "=q1=Plans: Darksoul Shoulders", "=ds=#p2# (300)" },
        { 20757, "INV_Misc_Note_01", "=q1=Formula: Brilliant Mana Oil", "=ds=#p4# (300)" },
        { 20001, "INV_Scroll_03", "=q1=Schematic: Bloodvine Lens", "=ds=#p5# (300)" },
        { 19771, "INV_Scroll_03", "=q1=Pattern: Primal Batskin Bracers", "=ds=#p7# (300)" },
        { 19766, "INV_Scroll_03", "=q1=Pattern: Bloodvine Boots", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 19858, "INV_Misc_Coin_08", "=q2=Zandalar Honor Token", "=ds=#m17#" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Coin_08", "=q6=#r3#", "" },
        { 20014, "INV_Scroll_03", "=q1=Recipe: Major Troll's Blood Potion", "=ds=#p1# (290)" },
        { 19777, "INV_Scroll_03", "=q1=Plans: Bloodsoul Shoulders", "=ds=#p2# (300)" },
        { 19780, "INV_Scroll_03", "=q1=Plans: Darksoul Leggings", "=ds=#p2# (300)" },
        { 20756, "INV_Misc_Note_01", "=q1=Formula: Brilliant Wizard Oil", "=ds=#p4# (300)" },
        { 20000, "INV_Scroll_03", "=q1=Schematic: Bloodvine Goggles", "=ds=#p5# (300)" },
        { 19773, "INV_Scroll_03", "=q1=Pattern: Blood Tiger Shoulders", "=ds=#p7# (300)" },
        { 19770, "INV_Scroll_03", "=q1=Pattern: Primal Batskin Gloves", "=ds=#p7# (300)" },
        { 19765, "INV_Scroll_03", "=q1=Pattern: Bloodvine Leggings", "=ds=#p8# (300)" },
        { 20031, "INV_Misc_Food_42", "=q1=Essence Mango", "=ds=#e3#", "", "1", "#zandalar#" },
        };
        
    Zandalar2 = {
        { 0, "INV_Misc_Coin_08", "=q6=#r4#", "" },
        { 20080, "INV_Potion_29", "=q2=Sheen of Zanza", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20079, "INV_Potion_30", "=q2=Spirit of Zanza", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20081, "INV_Potion_31", "=q2=Swiftness of Zanza", "=ds=#e2#", "", "3", "#zandalar#" },
        { 20011, "INV_Scroll_03", "=q1=Recipe: Mageblood Potion", "=ds=#p1# (275)" },
        { 19776, "INV_Scroll_03", "=q1=Plans: Bloodsoul Breastplate", "=ds=#p2# (300)" },
        { 19779, "INV_Scroll_03", "=q1=Plans: Darksoul Breastplate", "=ds=#p2# (300)" },
        { 19772, "INV_Scroll_03", "=q1=Pattern: Blood Tiger Breastplate", "=ds=#p7# (300)" },
        { 19769, "INV_Scroll_03", "=q1=Pattern: Primal Batskin Jerkin", "=ds=#p7# (300)" },
        { 19764, "INV_Scroll_03", "=q1=Pattern: Bloodvine Vest", "=ds=#p8# (300)" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "", "", "" },
        { 0, "INV_Misc_Coin_08", "=q6=#r5#", "" },
        { 20077, "INV_Misc_ArmorKit_08", "=q3=Zandalar Signet of Might", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20076, "INV_Jewelry_Ring_46", "=q3=Zandalar Signet of Mojo", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20078, "Spell_Holy_PowerWordShield", "=q3=Zandalar Signet of Serenity", "=ds=#s3# #e17#", "", "15", "#zandalar#" },
        { 20013, "INV_Scroll_03", "=q1=Recipe: Living Action Potion", "=ds=#p1# (285)" },
        };
 
    };
    